<?php
add_action( 'vc_before_init', 'dt_sc_google_map_vc_map' );
function dt_sc_google_map_vc_map() {

	vc_map( array(
		"name" => esc_html__( "Google Map", 'veda-core' ),
		"base" => "dt_sc_google_map",
		"category" => DT_VC_CATEGORY,
		"class" => "dt_vc_style",
		"icon" => "dt_sc_google_map",
		'as_parent' => array( 'only' => 'dt_sc_google_map_marker' ),
		"content_element" => true,
		"params" => array(

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Map Type', 'veda-core' ),
      			'param_name' => 'map_type',
      			'value' => array(
      				esc_html__('Roadmap','veda-core') => 'roadmap',
      				esc_html__('Satellite','veda-core') => 'satellite',
      				esc_html__('Terrain','veda-core') => 'terrain',
      				esc_html__('Hybrid','veda-core') => 'hybrid'
      			),
				'save_always' => true,
      			'description' => esc_html__( 'The popup window which appears when a marker is clicked.', 'veda-core' ),				
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Map Style', 'veda-core' ),
      			'param_name' => 'map_style',
      			'value' => array(
      				esc_html__('Default','veda-core') => '',
      				esc_html__('Custom','veda-core') => 'custom',
					esc_html__('Style 1','veda-core') => '1',
					esc_html__('Style 2','veda-core') => '2',
					esc_html__('Style 3','veda-core') => '3',
					esc_html__('Style 4','veda-core') => '4',
					esc_html__('Style 5','veda-core') => '5',
					esc_html__('Style 6','veda-core') => '6',
					esc_html__('Style 7','veda-core') => '7',
					esc_html__('Style 8','veda-core') => '8',
					esc_html__('Style 9','veda-core') => '9',
					esc_html__('Style 10','veda-core') => '10',
					esc_html__('Style 11','veda-core') => '11',
					esc_html__('Style 12','veda-core') => '12',
					esc_html__('Style 13','veda-core') => '13',
					esc_html__('Style 14','veda-core') => '14',
					esc_html__('Style 15','veda-core') => '15',
					esc_html__('Style 16','veda-core') => '16',
					esc_html__('Style 17','veda-core') => '17',
					esc_html__('Style 18','veda-core') => '18',
					esc_html__('Style 19','veda-core') => '19',
					esc_html__('Style 20','veda-core') => '20',
					esc_html__('Style 21','veda-core') => '21',
					esc_html__('Style 22','veda-core') => '22',
					esc_html__('Style 23','veda-core') => '23',
					esc_html__('Style 24','veda-core') => '24',
					esc_html__('Style 25','veda-core') => '25',
					esc_html__('Style 26','veda-core') => '26',
					esc_html__('Style 27','veda-core') => '27',
					esc_html__('Style 28','veda-core') => '28',
					esc_html__('Style 29','veda-core') => '29',
					esc_html__('Style 30','veda-core') => '30',
					esc_html__('Style 31','veda-core') => '31',
					esc_html__('Style 32','veda-core') => '32',
					esc_html__('Style 33','veda-core') => '33',
					esc_html__('Style 34','veda-core') => '34',
					esc_html__('Style 35','veda-core') => '35',
					esc_html__('Style 36','veda-core') => '36',
					esc_html__('Style 37','veda-core') => '37',
					esc_html__('Style 38','veda-core') => '38',
					esc_html__('Style 39','veda-core') => '39',
					esc_html__('Style 40','veda-core') => '40',
					esc_html__('Style 41','veda-core') => '41',
					esc_html__('Style 42','veda-core') => '42',
					esc_html__('Style 43','veda-core') => '43',
					esc_html__('Style 44','veda-core') => '44',
					esc_html__('Style 45','veda-core') => '45',
					esc_html__('Style 46','veda-core') => '46',
					esc_html__('Style 47','veda-core') => '47',
					esc_html__('Style 48','veda-core') => '48',
					esc_html__('Style 49','veda-core') => '49',
					esc_html__('Style 50','veda-core') => '50',      				
      			),
      			'description' => esc_html__( 'Choose map custom style.', 'veda-core' ),				
			),

			array(
				"type" => "colorpicker",
      			"heading" => esc_html__( "Custom Style", 'veda-core' ),
      			"param_name" => "custom_map_style",
      			"description" => esc_html__( "Select custom color for map", 'veda-core' ),
				'dependency' => array( 'element' => 'map_style', 'value' =>'custom' )				
			),

			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Map Width', 'veda-core' ),
				'param_name' => 'map_width',
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
				'value' => '100%',
      			'description' => esc_html__( 'In px or % , 100% for a responsive map.', 'veda-core' ),
			),

			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Map Height', 'veda-core' ),
				'param_name' => 'map_height',
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
				'value' => '500px',
      			'description' => esc_html__( 'In px or % ,eg: 500px or 30%.', 'veda-core' ),
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Map Zoom Level', 'veda-core' ),
      			'param_name' => 'map_zoom_level',
      			'value' => array( 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20),
				'save_always' => true,
				'std' => 13
			),			

			// Controls
			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Street View Control', 'veda-core' ),
      			'param_name' => 'map_street_view_control',
				'edit_field_class' => 'vc_col-sm-6',
      			'value' => array(
      				esc_html__('Enable','veda-core') => 'enable',
      				esc_html__('Disable','veda-core') => 'disable'
      			),
				'save_always' => true,
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Map Type Control', 'veda-core' ),
      			'param_name' => 'map_type_control',
				'edit_field_class' => 'vc_col-sm-6',
      			'value' => array(
      				esc_html__('Enable','veda-core') => 'enable',
      				esc_html__('Disable','veda-core') => 'disable'
      			),
				'save_always' => true,
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Zoom Control', 'veda-core' ),
      			'param_name' => 'map_zoom_control',
				'edit_field_class' => 'vc_col-sm-6',
      			'value' => array(
      				esc_html__('Enable','veda-core') => 'enable',
      				esc_html__('Disable','veda-core') => 'disable'
      			),
				'save_always' => true,
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Scale Control', 'veda-core' ),
      			'param_name' => 'map_scale_control',
				'edit_field_class' => 'vc_col-sm-6',
      			'value' => array(
      				esc_html__('Enable','veda-core') => 'enable',
      				esc_html__('Disable','veda-core') => 'disable'
      			),
				'save_always' => true,
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( 'Scroll wheel', 'veda-core' ),
      			'param_name' => 'map_scroll_wheel',
				'edit_field_class' => 'vc_col-sm-6',
      			'value' => array(
      				esc_html__('Enable','veda-core') => 'enable',
      				esc_html__('Disable','veda-core') => 'disable'
      			),
				'save_always' => true,
			),

			array(
      			'type' => 'dropdown',
      			'heading' => esc_html__( ' Draggable?', 'veda-core' ),
      			'param_name' => 'map_draggable',
				'edit_field_class' => 'vc_col-sm-6',
      			'value' => array(
      				esc_html__('Enable','veda-core') => 'enable',
      				esc_html__('Disable','veda-core') => 'disable'
      			),
				'save_always' => true,
			),

			vc_map_add_css_animation(),

			array(
				"type" => "textfield",
				"heading" => __("Animation delay ( optional )", 'veda-core'),
				"edit_field_class" => 'vc_col-sm-6 vc_column',
				"param_name" => "delay",
				"value" => "0",
				"description" => __("Set the animation delay ( e.g 200 )", 'veda-core')
			),			
			// Controls
			
			// Markers
			array(
				'type' => 'param_group',
				'param_name' => 'map_markers',
				'group' => esc_html__( 'Markers', 'veda-core' ),
				'params' => array(

					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Latitude', 'veda-core' ),
						'param_name' => 'marker_latitude',
						'save_always' => true
					),

					array(
						'type' => 'textfield',
						'heading' => esc_html__( 'Longitude', 'veda-core' ),
						'param_name' => 'marker_longitude',
						'save_always' => true
					),

					array(
						'type' => 'textarea_raw_html',
						'heading' => esc_html__('Content', 'veda-core'),
						'param_name' => 'marker_content',
					),

					array(
		      			'type' => 'dropdown',
		      			'heading' => esc_html__( 'Icon', 'veda-core' ),
		      			'param_name' => 'marker_icon',
						'save_always' => true,
		      			'value' => array( 
		      				esc_html__('Built in','veda-core') => 'pin.png',
		      				esc_html__('Custom','veda-core') => 'custom',
		      				esc_html__('Black','veda-core') => 'black.png',
		      				esc_html__('Blue','veda-core') => 'blue.png',
		      				esc_html__('Gray','veda-core') => 'gray.png',
		      				esc_html__('Green','veda-core') => 'green.png',
		      				esc_html__('Magenta','veda-core') => 'magenta.png',
		      				esc_html__('Orange','veda-core') => 'orange.png',
		      				esc_html__('Purple','veda-core') => 'purple.png',
		      				esc_html__('Red','veda-core') => 'red.png',
		      				esc_html__('White','veda-core') => 'white.png',
		      				esc_html__('Yellow','veda-core') => 'yellow.png',
		      			),
		      			'description' => esc_html__( 'Select marker icon', 'veda-core' ),
		      			'std' => 'green.png',
					),

					array(
						"type" => "attach_image",
		      			"heading" => esc_html__( "Custom Marker icon", 'veda-core' ),
		      			"param_name" => "custom_marker_icon",
		      			"group" => esc_html__( 'Marker', 'veda-core' ),
		      			"description" => esc_html__( "Select custom marker icon", 'veda-core' ),
						'dependency' => array( 'element' => 'marker_icon', 'value' =>'custom' )				
					),

					array(
		      			'type' => 'dropdown',
		      			'heading' => esc_html__( 'Popup Window', 'veda-core' ),
		      			'group' => esc_html__( 'Marker', 'veda-core' ),
		      			'param_name' => 'popup',
		      			'value' => array(
		      				esc_html__('Hidden','veda-core') => 'hidden',
		      				esc_html__('Visible','veda-core') => 'visible'
		      			),
						'save_always' => true,
		      			'description' => esc_html__( 'The popup window which appears when a marker is clicked.', 'veda-core' ),
					),
				)
			)
			// markers
		)
	) );
}
